	function [L, C, K] = LP_2_BP_LADDER(L, C, K, WIsquared)
 
	%	Converts a doubly resistively lowpass LC ladder into a
	%	bandpass LC ladder. If the lowpass filter has the passband 
	% 	edge Omegac then the bandpass filter will have a bandwidth 
	%	equal to Omegac.
	%
	%	K is a vector used by LADDER_2_H that defines the type
	%	of elements in the ladder. The  ladder sholud be modified by
	%	using Norton transformations in order to remove the high 
	%	impedance node between the two parallel resonance circuits.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 			Lars Wanhammar, 2008-12-14
	% 	Modified by: 	 	
	%	Copyright:			Divison of Electronics Systems
	%	 					Dept. Electrical Engineering, Linkoping University, Sweden
	% 	Version:			1
	% 	Known bugs:			 
	% 	Report bugs to:		Wanhammar@gmail.com
	
	Wi = sqrt(WIsquared);
	j = 1; n = 1;
	while n <= length(K)
		if K(n) == 2	% Series inductor -> Series resonance circuit in the series arm
			TempK(j) = 4; 
			TempL(j) = L(n);
			TempC(j) = 1/L(n)/Wi^2;
		end
	
		if K(n) == 9	% Shunt capacitor -> A shunt parallel resonance circuit in the shunt arm
			TempK(j) = 11;
			TempC(j) = C(n);
			TempL(j) = 1/C(n)/Wi^2;
		end
	
		if K(n) == 5	% Parallel resonance circuit in series arm ->
			% Two parallel resonance circuits in series in the series arm
			Omega = 1/sqrt(L(n)*C(n));
			x = Omega/2/Wi;
			b = sqrt(x^2 + 1);
			W01 = b + x;
			W02 = b - x;
			TempK(j) = 5;
			TempK(j+1) = 5;
			TempL(j) = 1/(C(n)*(1 + W01^2))/Wi^2;
			TempL(j+1) = 1/(C(n)*(1 + W02^2))/Wi^2;
			TempC(j) = C(n)*(1 + W02^2);
			TempC(j+1) = C(n)*(1 + W01^2);
			j = j+1;	
		end
	
		if K(n) == 10	% Series resonance circuit in shunt arm ->
			% Two parallel series resonance circuits in  the shunt arm
			Omega = 1/sqrt(L(n)*C(n));
			x = Omega/2/Wi;
			b = sqrt(x^2 + 1);
			W01 = b + x;
			W02 = b - x;
			TempK(j) = 10;
			TempK(j+1) = 10;
			TempL(j) = L(n)*(1 + W02^2);
			TempL(j+1) = L(n)*(1 + W01^2);
			TempC(j) = 1/(L(n)*(1 + W01^2))/Wi^2;
			TempC(j+1) = 1/(L(n)*(1 + W02^2))/Wi^2;
			j = j+1;
		end
		j = j+1; n=n+1;
	end
	K = TempK;
	L = TempL;
	C = TempC;
